/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.HexDump;
import com.ibm.hsc.fsp.AsyncEventHandler;
import com.ibm.hsc.fsp.FSPCMIdGenerator;
import com.ibm.hsc.fsp.HWSvrSocket;
import java.io.IOException;
import java.util.Vector;

public class AsyncEventListener
extends Thread {
    private AsyncEventHandler m_eventHandler = null;
    private boolean m_closed = false;
    private Vector mMessageQueue = new Vector();
    private boolean mInWaiting = false;
    private static final byte[] m_emptyVport = new byte[]{0, 0, 0, 0};
    private static final String LOCAL_HOST_NAME = "localhost";
    private static final int HARDWARE_SERVER_PORT = 8877;
    private static final int ASYNC_REG_MAJOR = 32;
    private static final int FSP_ASYNC_REG_MINOR = 58;
    private static final int BPA_ASYNC_REG_MINOR = 73;
    private static final int ASYNC_NOTIFY_MAJOR = 160;

    public AsyncEventListener(AsyncEventHandler asyncEventHandler) {
        this.m_eventHandler = asyncEventHandler;
        this.m_closed = false;
        this.start();
    }

    public void initialize(int n, boolean bl) throws PIHscCmdMgrException, IOException {
        this.registerAsyncHandler(n, bl);
        System.out.println("Starts the async listener thread");
    }

    public void initialize(byte[] byArray, boolean bl) throws PIHscCmdMgrException, IOException {
        for (int i = 0; i < 4; ++i) {
            System.out.println("Async listener reg vport[" + i + "] = " + Integer.toHexString(byArray[i]));
        }
        this.initialize(HardwareServerMessage.bytesToUInt(byArray, 0), bl);
    }

    private void registerAsyncHandler(int n, boolean bl) throws IOException {
        int n2 = FSPCMIdGenerator.getInstance().genReqId();
        int n3 = bl ? 58 : 73;
        HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildCustomHWSMessage(32, n3, n, n2, null);
        byte[] byArray = hardwareServerMessage.toBytes();
        System.out.println("start HANDLING ASYNC REG");
        System.out.println("print async reg data " + new HexDump(byArray).toString());
        HWSvrSocket.getInstance().sendCommand(byArray);
    }

    public void setRegResp(HardwareServerMessage hardwareServerMessage) {
        int n = hardwareServerMessage.getMinorOpCode();
        byte[] byArray = hardwareServerMessage.getPayload();
        if (n == 60 || n == 75) {
            int n2 = HardwareServerMessage.bytesToUInt(byArray, 0);
            System.out.println("Async registration failed  with errcode: " + n2 + " minor code is " + n);
            return;
        }
    }

    public synchronized void addNewMessage(HardwareServerMessage hardwareServerMessage) {
        System.out.println(">>>>>>>> interrupt the waiting thread " + this.mInWaiting + "Async thread " + this.getName());
        this.mMessageQueue.addElement(hardwareServerMessage);
        if (this.mInWaiting) {
            try {
                this.notify();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private synchronized HardwareServerMessage getNextMessage() {
        while (this.mMessageQueue.size() == 0 && !this.m_closed) {
            this.mInWaiting = true;
            try {
                this.wait();
            }
            catch (Throwable throwable) {
                this.mInWaiting = false;
                System.out.println("Async thread has been wakeup");
            }
        }
        if (this.m_closed) {
            System.out.println("exit get message for close");
            return null;
        }
        return (HardwareServerMessage)this.mMessageQueue.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMsgTable() {
        AsyncEventListener asyncEventListener = this;
        synchronized (asyncEventListener) {
            this.mMessageQueue.clear();
        }
    }

    public void run() {
        try {
            HardwareServerMessage hardwareServerMessage;
            while (!this.m_closed && (hardwareServerMessage = this.getNextMessage()) != null) {
                System.out.println("got an async event, tha payload is " + hardwareServerMessage);
                this.m_eventHandler.handleEvent(hardwareServerMessage.getMinorOpCode(), hardwareServerMessage.getVirtualPortInByteArray(), hardwareServerMessage.getPayload(), hardwareServerMessage.getFspUniqueId());
            }
            System.out.println("out of async loop");
        }
        catch (Throwable throwable) {
            this.m_eventHandler.handleError(throwable);
            throwable.printStackTrace();
        }
    }

    public void close() {
        System.out.println("in async close");
        if (!this.m_closed) {
            this.m_closed = true;
            try {
                System.out.println("before interrupt async thread");
                this.interrupt();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

